//
//  TestBasicDoc.m
//  HNSAppKit
//
//  Created by Dr. H. Nikolaus Schaller on Thu Mar 06 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import "TestBasicDoc.h"
#import <HNSAppKit/HNSBasicCompiler.h>
#import <HNSAppKit/HNSSyntaxAwareTextView.h>

@implementation TestBasicDoc

- (void) awakeFromNib;
{
#if 0
	NSLog(@"TestBasicDoc: awakeFromNib");
#endif
	[source setKeywordResourceFile:[[NSBundle bundleForClass:[HNSBasicCompiler class]] pathForResource:@"HNSBasicKeywords" ofType:@"plist"]];	// use same as HNSBasicCompiler
	[source autoHighlight:YES];	// automatically highlight after all changes
	if(st)
		[source setString:st];	// Open...
	else
		[source setString:@"SUB subroutine\n  // your code goes here\nEND SUB"];	// New
	[source highlightSyntax];
	[source setAllowsUndo:YES];
#if 0
	NSLog(@"NSApp %@", NSApp);
	NSLog(@"NSApp delegate %@", [NSApp delegate]);
	NSLog(@"controller %@", [NSDocumentController sharedDocumentController]);
	NSLog(@"type of .ccb %@", [[NSDocumentController sharedDocumentController] typeFromFileExtension:@"ccb"]);
	NSLog(@"type of doc %@", [self fileType]);
	NSLog(@"name of doc %@", [self fileName]);
	NSLog(@"window controllers %@", [self windowControllers]);
#endif
}

- (BOOL)hasUndoManager;
{
	return YES;
}

- (NSString *)windowNibName {
    // Implement this to return a nib to load OR implement -makeWindowControllers to manually create your controllers.
    return @"TestBasicDoc";
}

- (NSData *)dataRepresentationOfType:(NSString *)type {
	return [[source string] dataUsingEncoding:NSUTF8StringEncoding];
}

- (BOOL)loadDataRepresentation:(NSData *)data ofType:(NSString *)type {
	st=[[NSString alloc] initWithData:data encoding:NSUTF8StringEncoding];
	if(st == nil)
		return NO;
#if 0
	NSLog(@"%@", st);
#endif
    // Implement to load a persistent data representation of your document OR remove this and implement the file-wrapper or file path based load methods.
    return YES;
}

static BOOL err;	// communicate to run:

- (IBAction) compile:(id) Sender;
{
	NSString *ss;
#if 0
	NSLog(@"by: %@", [HNSBasicCompiler sharedCompiler]);
	NSLog(@"compile: %@", [source string]);
#endif
	err=NO;
	NS_DURING	// set up exception handler!
		[self saveDocument:Sender];	// save (if needed)
		ss=[HNSBasicCompiler compile:[source string]];
		[NSApp setScript:ss];
	NS_HANDLER
		{ // exception, i.e. syntax error or alike
			err=YES;
			[NSApp setScript:[HNSBasicCompiler code]];	// show compiled code
#if 0
			NSLog(@"exception in line %d: %@", [HNSBasicCompiler linenumber], [localException name]);
#endif
			[source setSelectedRange:NSMakeRange([HNSBasicCompiler errorPos], 0)];	// show scanner location
			NSRunAlertPanel([localException name], @"at line %d\n%@", @"OK", nil, nil, [HNSBasicCompiler linenumber], localException);
		}
	NS_ENDHANDLER
#if 0
		NSLog(@"code:\n%@", [HNSBasicCompiler code]);
#endif
}

- (IBAction) run:(id) Sender;
{ // compile and run
	[self compile:Sender];			// compile Basic -> CocoaScript
	if(!err)
		[NSApp runScript:Sender];		// and run compiled code
}

@end
